<?php
/*------------------------------------------------------------------------------
 SummaryPartials.php 2021-05-27
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -----------------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\DashboardWidget\Model\Collections;

use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Model\ValueObjects\SummaryPartial;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Support\AbstractCollection;

class SummaryPartials extends AbstractCollection
{
    /**
     * @inheritDoc
     */
    public function current(): SummaryPartial
    {
        return $this->currentValue();
    }
    
    
    /**
     * @inheritDoc
     */
    protected function isValid($value): bool
    {
        return $value instanceof SummaryPartial;
    }
}